document.addEventListener("DOMContentLoaded", function () {
    const params = new URLSearchParams(window.location.search);
    const title = params.get("title") || "gallery";
    const category = params.get("category") || "branding";

    // تحديث عنوان الصفحة باستخدام data-translate
    document.getElementById("gallery-title").setAttribute("data-translate", title);

    // قائمة المشاريع والصور
    const projects = [
      {
        image: "images/Exhibition Booths & Events/Booths/Santen3/8.jpg",
        title: "santen3",
      
        category: "branding",
      },
      {
        image: "images/Exhibition Booths & Events/Booths/Santen 2/3.jpg",
        title: "santen2",
      
        category: "branding",
      },
        {
            image: "images/Exhibition Booths & Events/Booths/AKSUM Armored/01.jpg",
            title: "askum_armored",
            category: "branding",
          },
          {
            image: "images/Exhibition Booths & Events/Booths/AKSUM Marine/02.jpg",
            title: "askum_marine",
            category: "branding",
          },
          {
            image: "images/Exhibition Booths & Events/Booths/Almera Foods/03.jpg",
            title: "almera_foods",
            category: "branding",
          },
          {
            image: "images/Exhibition Booths & Events/Booths/Anti-Corruption Forum/15.jpg",
            title: "moe",
           
            category: "branding",
          },
          {
            image: "images/Exhibition Booths & Events/Booths/BRF/01.jpg",
            title: "brf",
           
            category: "branding",
          },
          {
            image: "images/Exhibition Booths & Events/Booths/Damak/01.jpg",
            title: "damak",
           
            category: "branding",
          },
          {
            image: "images/Exhibition Booths & Events/Booths/Delta Plast/Wide (5).jpg",
            title: "delta_plast",
        
            category: "branding",
          },
         
          {
            image: "images/Exhibition Booths & Events/Booths/Hero One/01.jpg",
            title: "hero_one",
            
            category: "branding",
          },
          {
            image: "images/Exhibition Booths & Events/Booths/Evaco/03.jpg",
            title: "evaco",
           
            category: "branding",
          },
          {
            image: "images/Exhibition Booths & Events/Booths/Falcon/04.jpg",
            title: "falcon",
          
            category: "branding",
          },
          {
            image: "images/Exhibition Booths & Events/Booths/INKAS/01.jpg",
            title: "inkas",
            
            category: "branding",
          },
          {
            image: "images/Exhibition Booths & Events/Booths/Jazirah aviation club/04.jpg",
            title: "jac",
           
            category: "branding",
          },
          {
            image: "images/Exhibition Booths & Events/Booths/Kratos Glass/01.jpg",
            title: "kratos",
          
            category: "branding",
          },
          {
            image: "images/Exhibition Booths & Events/Booths/Riyadh Chamber/01.jpg",
            title: "riyadh_chamber",
         
            category: "branding",
          },
          {
            image: "images/Exhibition Booths & Events/Booths/SMC Hospital/10.jpg",
            title: "smc",
         
            category: "branding",
          },
          {
            image: "images/Exhibition Booths & Events/Booths/Sports Council/01.jpg",
            title: "adsc",
         
            category: "branding",
          },
          {
            image: "images/Exhibition Booths & Events/Booths/Unilime/01.jpg",
            title: "unilime",
          
            category: "branding",
          },
          {
            image: "images/Exhibition Booths & Events/Booths/UNI-Recycling/01.jpg",
            title: "unirecycling",
          
            category: "branding",
          },
          {
            image: "images/Exhibition Booths & Events/Booths/UNI-Recycling/01.jpg",
            title: "unirecycling",
          
            category: "branding",
          },
          {
            image: "images/Exhibition Booths & Events/Booths/Santen/03.jpg",
            title: "santen",
          
            category: "branding",
          },
          {
            image: "images/Exhibition Booths & Events/Events/Maili _ Sinclair/1 (1).jpg",
            title: "sinclair",
          
            category: "logo",
          },
          {
            image: "images/Exhibition Booths & Events/Booths/Sinclir/1.jpg",
            title: "sinclair2",
          
            category: "branding",
          },
          {
            image: "images/Exhibition Booths & Events/Events/Ministry leaders workshop/1.jpg",
            title: "ministry",
          
            category: "logo",
          },
          {
            image: "images/Exhibition Booths & Events/Events/Ministry of Agriculture event/01.jpg",
            title: "moaevent",
          
            category: "logo",
          },
          {
            image: "images/Exhibition Booths & Events/Events/Mo_asher/01.png",
            title: "moasher",
          
            category: "logo",
          },
          {
            image: "images/Exhibition Booths & Events/Events/Verkazia/01.jpg",
            title: "verkazia",
          
            category: "logo",
          },
          {
            image: "images/Exhibition Booths & Events/Decor/Mugla/1 (2).jpeg",
            title: "mugla",
          
            category: "illustration",
          },
          {
            image: "images/Exhibition Booths & Events/Decor/Arganic/1 (1).jpg",
            title: "argainc",
          
            category: "illustration",
          },
          {
            image: "images/Exhibition Booths & Events/Decor/Farog/1 (1).jpeg",
            title: "farog",
          
            category: "illustration",
          },
          {
            image: "images/Exhibition Booths & Events/Photo/4.png",
            title: "mugla_vid",
          
            category: "video",
          },
          {
            image: "images/Exhibition Booths & Events/Photo/1.png",
            title: "allure",
          
            category: "video",
          },
          {
            image: "images/Exhibition Booths & Events/Photo/3.png",
            title: "health_care",
          
            category: "video",
          },
          {
            image: "images/Exhibition Booths & Events/Photo/2.png",
            title: "sedra",
          
            category: "video",
          },
          {
            image: "images/Exhibition Booths & Events/Tech/2.png",
            title: "details_malqa",
          
            category: "tech",
          },
          {
            image: "images/Exhibition Booths & Events/Tech/1.png",
            title: "waf",
          
            category: "tech",
          },
          {
            image: "images/Exhibition Booths & Events/Tech/4.png",
            title: "king_salman",
          
            category: "tech",
          },
          {
            image: "images/Exhibition Booths & Events/Tech/3.png",
            title: "higher_learning",
          
            category: "tech",
          },
       
       
          
        
    ];

    const projectImages = {
        askum_armored: [
            { src: "images/Exhibition Booths & Events/Booths/AKSUM Armored/01.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/AKSUM Armored/02.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/AKSUM Armored/03.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/AKSUM Armored/04.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/AKSUM Armored/05.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/AKSUM Armored/06.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/AKSUM Armored/07.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/AKSUM Armored/08.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/AKSUM Armored/09.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/AKSUM Armored/10.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/AKSUM Armored/11.jpg", video: "" },
        ],
        sinclair2: [
          { src: "images/Exhibition Booths & Events/Booths/Sinclir/1.jpg", video: "" },
          { src: "images/Exhibition Booths & Events/Booths/Sinclir/2.jpg", video: "" },
          { src: "images/Exhibition Booths & Events/Booths/Sinclir/3.jpg", video: "" },
          { src: "images/Exhibition Booths & Events/Booths/Sinclir/4.jpg", video: "" },
          { src: "images/Exhibition Booths & Events/Booths/Sinclir/5.jpg", video: "" },
          { src: "images/Exhibition Booths & Events/Booths/Sinclir/6.jpg", video: "https://drive.google.com/file/d/1pOrFmQFmTAL3cl2W_QrhEOnU4iV71__g/view?usp=sharing" },

      ],
      santen2: [
        { src: "images/Exhibition Booths & Events/Booths/Santen 2/1.jpg", video: "" },
        { src: "images/Exhibition Booths & Events/Booths/Santen 2/2.jpg", video: "" },
        { src: "images/Exhibition Booths & Events/Booths/Santen 2/3.jpg", video: "" },
        { src: "images/Exhibition Booths & Events/Booths/Santen 2/4.jpg", video: "" },
        { src: "images/Exhibition Booths & Events/Booths/Santen 2/5.jpg", video: "" },
        { src: "images/Exhibition Booths & Events/Booths/Santen 2/6.jpg", video: "" },
    ],
    santen3: [
      { src: "images/Exhibition Booths & Events/Booths/Santen3/1.jpg", video: "" },
    { src: "images/Exhibition Booths & Events/Booths/Santen3/2.jpg", video: "" },
    { src: "images/Exhibition Booths & Events/Booths/Santen3/3.jpg", video: "" },
    { src: "images/Exhibition Booths & Events/Booths/Santen3/4.jpg", video: "" },
    { src: "images/Exhibition Booths & Events/Booths/Santen3/5.jpg", video: "" },
    { src: "images/Exhibition Booths & Events/Booths/Santen3/6.jpg", video: "" },
    { src: "images/Exhibition Booths & Events/Booths/Santen3/7.jpg", video: "" },
    { src: "images/Exhibition Booths & Events/Booths/Santen3/8.jpg", video: "" },
    { src: "images/Exhibition Booths & Events/Booths/Santen3/9.jpg", video: "" },
    { src: "images/Exhibition Booths & Events/Booths/Santen3/10.jpg", video: "" },
    { src: "images/Exhibition Booths & Events/Booths/Santen3/11.jpg", video: "" },
    { src: "images/Exhibition Booths & Events/Booths/Santen3/12.jpg", video: "https://drive.google.com/file/d/11ElX34JAT_FvJM_9AJ40wpqpNBmytSBG/view?usp=sharing" },
  ],
    
        askum_marine: [
            { src: "images/Exhibition Booths & Events/Booths/AKSUM Marine/01.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/AKSUM Marine/02.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/AKSUM Marine/03.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/AKSUM Marine/04.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/AKSUM Marine/05.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/AKSUM Marine/06.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/AKSUM Marine/09.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/AKSUM Marine/11.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/AKSUM Marine/13.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/AKSUM Marine/14.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/AKSUM Marine/15.jpg", video: "" },
        ],

        almera_foods: [
            { src: "images/Exhibition Booths & Events/Booths/Almera Foods/01.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/Almera Foods/02.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/Almera Foods/03.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/Almera Foods/04.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/Almera Foods/05.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/Almera Foods/07.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/Almera Foods/09.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/Almera Foods/10.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/Almera Foods/12.jpg", video: "" },
            { src: "images/دوExhibition Booths & Events/Booths/Almera Foods/14.jpg", video: "" },
        ],
        moe: [
            { src: "images/Exhibition Booths & Events/Booths/Anti-Corruption Forum/01.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/Anti-Corruption Forum/03.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/Anti-Corruption Forum/05.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/Anti-Corruption Forum/07.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/Anti-Corruption Forum/08.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/Anti-Corruption Forum/09.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/Anti-Corruption Forum/11.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/Anti-Corruption Forum/13.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/Anti-Corruption Forum/15.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/Anti-Corruption Forum/16.jpg", video: "" },
        ],
        brf: [
            { src: "images/Exhibition Booths & Events/Booths/BRF/01.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/BRF/02.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/BRF/03.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/BRF/05.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/BRF/06.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/BRF/07.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/BRF/13.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/BRF/14.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/BRF/20.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/BRF/21.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/BRF/22.jpg", video: "" },
        ],
        damak: [
            { src: "images/Exhibition Booths & Events/Booths/Damak/01.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/Damak/02.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/Damak/04.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/Damak/07.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/Damak/09.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/Damak/12.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/Damak/13.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/Damak/16.jpg", video: "" },
        ],
        delta_plast: [
            { src: "images/Exhibition Booths & Events/Booths/Delta Plast/Close (6).jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/Delta Plast/Close (7).jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/Delta Plast/Close (8).jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/Delta Plast/Wide (1).jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/Delta Plast/Wide (2).jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/Delta Plast/Wide (3).jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/Delta Plast/Wide (4).jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/Delta Plast/Wide (5).jpg", video: "" },
        ],

        evaco: [
            { src: "images/Exhibition Booths & Events/Booths/Evaco/02.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/Evaco/03.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/Evaco/04.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/Evaco/08.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/Evaco/09.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/Evaco/11.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/Evaco/12.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/Evaco/13.jpg", video: "" },
        ],
        falcon: [
            { src: "images/Exhibition Booths & Events/Booths/Falcon/02.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/Falcon/03.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/Falcon/04.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/Falcon/05.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/Falcon/08.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/Falcon/10.jpg", video: "" },
        ],
        hero_one: [
            { src: "images/Exhibition Booths & Events/Booths/Hero One/01.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/Hero One/02.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/Hero One/03.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/Hero One/04.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/Hero One/08.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/Hero One/11.jpg", video: "" },
        ],
        inkas: [
            { src: "images/Exhibition Booths & Events/Booths/INKAS/01.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/INKAS/02.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/INKAS/03.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/INKAS/05.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/INKAS/08.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/INKAS/10.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/INKAS/12.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/INKAS/14.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/INKAS/15.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/INKAS/16.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/INKAS/18.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/INKAS/19.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/INKAS/21.jpg", video: "" },
        ],
        jac: [
            { src: "images/Exhibition Booths & Events/Booths/Jazirah aviation club/01.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/Jazirah aviation club/02.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/Jazirah aviation club/03.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/Jazirah aviation club/04.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/Jazirah aviation club/05.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/Jazirah aviation club/07.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/Jazirah aviation club/09.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/Jazirah aviation club/10.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/Jazirah aviation club/11.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/Jazirah aviation club/13.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/Jazirah aviation club/14.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/Jazirah aviation club/16.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/Jazirah aviation club/17.jpg", video: "" },
        ],
        kratos: [
            { src: "images/Exhibition Booths & Events/Booths/Kratos Glass/01.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/Kratos Glass/02.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/Kratos Glass/03.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/Kratos Glass/04.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/Kratos Glass/06.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/Kratos Glass/07.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/Kratos Glass/10.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/Kratos Glass/11.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/Kratos Glass/12.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/Kratos Glass/13.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/Kratos Glass/14.jpg", video: "" },
        ],
        riyadh_chamber: [
            { src: "images/Exhibition Booths & Events/Booths/Riyadh Chamber/01.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/Riyadh Chamber/02.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/Riyadh Chamber/03.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/Riyadh Chamber/04.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/Riyadh Chamber/05.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/Riyadh Chamber/06.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/Riyadh Chamber/07.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/Riyadh Chamber/12.jpg", video: "" },
        ],
        santen: [
            { src: "images/Exhibition Booths & Events/Booths/Santen/01.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/Santen/02.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/Santen/03.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/Santen/04.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/Santen/05.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/Santen/06.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/Santen/07.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/Santen/08.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/Santen/11.jpg", video: "" },
        ],
        smc: [
            { src: "images/Exhibition Booths & Events/Booths/SMC Hospital/02.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/SMC Hospital/08.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/SMC Hospital/10.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/SMC Hospital/11.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/SMC Hospital/12.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/SMC Hospital/13.jpg", video: "" },
        ],
        adsc: [
            { src: "images/Exhibition Booths & Events/Booths/Sports Council/01.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/Sports Council/02.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/Sports Council/03.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/Sports Council/04.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/Sports Council/05.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/Sports Council/06.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/Sports Council/09.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/Sports Council/10.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/Sports Council/11.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/Sports Council/14.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/Sports Council/15.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/Sports Council/18.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/Sports Council/20.jpg", video: "" },
        ],
        unilime: [
            { src: "images/Exhibition Booths & Events/Booths/Unilime/01.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/Unilime/02.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/Unilime/03.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/Unilime/04.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/Unilime/06.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/Unilime/07.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/Unilime/08.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/Unilime/09.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/Unilime/11.jpg", video: "" },
        ],
        unirecycling: [
            { src: "images/Exhibition Booths & Events/Booths/UNI-Recycling/01.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/UNI-Recycling/02.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/UNI-Recycling/03.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/UNI-Recycling/04.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/UNI-Recycling/05.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/UNI-Recycling/06.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/UNI-Recycling/09.jpg", video: "" },
            { src: "images/Exhibition Booths & Events/Booths/UNI-Recycling/11.jpg", video: "" },
        ],
        moasher: [
            { src: "images/Exhibition Booths & Events/Events/Mo_asher/01.png", video: "" },
            { src: "images/Exhibition Booths & Events/Events/Mo_asher/02.png", video: "" },
            { src: "images/Exhibition Booths & Events/Events/Mo_asher/03.png", video: "" },
            { src: "images/Exhibition Booths & Events/Events/Mo_asher/04.png", video: "" },
            { src: "images/Exhibition Booths & Events/Events/Mo_asher/05.png", video: "" },
            { src: "images/Exhibition Booths & Events/Events/Mo_asher/06.png", video: "" },
            { src: "images/Exhibition Booths & Events/Events/Mo_asher/07.png", video: "" },
        ],
        ministry: [
            { "src": "images/Exhibition Booths & Events/Events/Ministry leaders workshop/1.jpg", "video": "" },
            { "src": "images/Exhibition Booths & Events/Events/Ministry leaders workshop/2.png", "video": "" },
            { "src": "images/Exhibition Booths & Events/Events/Ministry leaders workshop/3.png", "video": "" },
            { "src": "images/Exhibition Booths & Events/Events/Ministry leaders workshop/4.png", "video": "" },
            { "src": "images/Exhibition Booths & Events/Events/Ministry leaders workshop/5.png", "video": "" },
            { "src": "images/Exhibition Booths & Events/Events/Ministry leaders workshop/6.png", "video": "" },
            { "src": "images/Exhibition Booths & Events/Events/Ministry leaders workshop/7.png", "video": "" },
            { "src": "images/Exhibition Booths & Events/Events/Ministry leaders workshop/8.png", "video": "" },
            { "src": "images/Exhibition Booths & Events/Events/Ministry leaders workshop/9.png", "video": "" },
            { "src": "images/Exhibition Booths & Events/Events/Ministry leaders workshop/10.png", "video": "" },
            { "src": "images/Exhibition Booths & Events/Events/Ministry leaders workshop/11.png", "video": "" },
            { "src": "images/Exhibition Booths & Events/Events/Ministry leaders workshop/12.png", "video": "" },
            { "src": "images/Exhibition Booths & Events/Events/Ministry leaders workshop/13.png", "video": "" },
            { "src": "images/Exhibition Booths & Events/Events/Ministry leaders workshop/14.png", "video": "" },
            { "src": "images/Exhibition Booths & Events/Events/Ministry leaders workshop/15.png", "video": "" },
            { "src": "images/Exhibition Booths & Events/Events/Ministry leaders workshop/16.png", "video": "" }
        ],
        moaevent: [
            { "src": "images/Exhibition Booths & Events/Events/Ministry of Agriculture event/01.jpg", "video": "" },
            { "src": "images/Exhibition Booths & Events/Events/Ministry of Agriculture event/02.jpg", "video": "" },
            { "src": "images/Exhibition Booths & Events/Events/Ministry of Agriculture event/03.jpg", "video": "" },
            { "src": "images/Exhibition Booths & Events/Events/Ministry of Agriculture event/04.jpg", "video": "" },
            { "src": "images/Exhibition Booths & Events/Events/Ministry of Agriculture event/05.jpg", "video": "" },
            { "src": "images/Exhibition Booths & Events/Events/Ministry of Agriculture event/06.jpg", "video": "" },
            { "src": "images/Exhibition Booths & Events/Events/Ministry of Agriculture event/07.jpg", "video": "" },
            { "src": "images/Exhibition Booths & Events/Events/Ministry of Agriculture event/08.jpg", "video": "" },
            { "src": "images/Exhibition Booths & Events/Events/Ministry of Agriculture event/09.jpg", "video": "" },
            { "src": "images/Exhibition Booths & Events/Events/Ministry of Agriculture event/10.jpg", "video": "" },
            { "src": "images/Exhibition Booths & Events/Events/Ministry of Agriculture event/11.jpg", "video": "" }
        ],
        moasher: [
            { "src": "images/Exhibition Booths & Events/Events/Mo_asher/01.png", "video": "" },
            { "src": "images/Exhibition Booths & Events/Events/Mo_asher/02.png", "video": "" },
            { "src": "images/Exhibition Booths & Events/Events/Mo_asher/03.png", "video": "" },
            { "src": "images/Exhibition Booths & Events/Events/Mo_asher/04.png", "video": "" },
            { "src": "images/Exhibition Booths & Events/Events/Mo_asher/05.png", "video": "" },
            { "src": "images/Exhibition Booths & Events/Events/Mo_asher/06.png", "video": "" },
            { "src": "images/Exhibition Booths & Events/Events/Mo_asher/07.png", "video": "" }
        ],
        verkazia:[
            { "src": "images/Exhibition Booths & Events/Events/Verkazia/01.jpg", "video": "" },
            { "src": "images/Exhibition Booths & Events/Events/Verkazia/02.jpg", "video": "" },
            { "src": "images/Exhibition Booths & Events/Events/Verkazia/03.jpg", "video": "" },
            { "src": "images/Exhibition Booths & Events/Events/Verkazia/04.jpg", "video": "" },
            { "src": "images/Exhibition Booths & Events/Events/Verkazia/05.jpg", "video": "" },
            { "src": "images/Exhibition Booths & Events/Events/Verkazia/06 (1).jpg", "video": "" },
            { "src": "images/Exhibition Booths & Events/Events/Verkazia/06.jpg", "video": "" },
            { "src": "images/Exhibition Booths & Events/Events/Verkazia/07 (1).jpg", "video": "" },
            { "src": "images/Exhibition Booths & Events/Events/Verkazia/07.jpg", "video": "" },
            { "src": "images/Exhibition Booths & Events/Events/Verkazia/08.jpg", "video": "" },
            { "src": "images/Exhibition Booths & Events/Events/Verkazia/09 (1).jpg", "video": "" },
            { "src": "images/Exhibition Booths & Events/Events/Verkazia/09.jpg", "video": "" },
            { "src": "images/Exhibition Booths & Events/Events/Verkazia/10.jpg", "video": "" },
            { "src": "images/Exhibition Booths & Events/Events/Verkazia/11.jpg", "video": "" }
        ],
        
        mugla:[
            { "src": "images/Exhibition Booths & Events/Decor/Mugla/1 (1).jpeg", "video": "" },
            { "src": "images/Exhibition Booths & Events/Decor/Mugla/1 (2).jpeg", "video": "" },
            { "src": "images/Exhibition Booths & Events/Decor/Mugla/1 (3).jpeg", "video": "" },
            { "src": "images/Exhibition Booths & Events/Decor/Mugla/1 (4).jpeg", "video": "" },
            { "src": "images/Exhibition Booths & Events/Decor/Mugla/1 (5).jpeg", "video": "" },
            { "src": "images/Exhibition Booths & Events/Decor/Mugla/1 (6).jpeg", "video": "" },
            { "src": "images/Exhibition Booths & Events/Decor/Mugla/1 (7).jpeg", "video": "" },
            { "src": "images/Exhibition Booths & Events/Decor/Mugla/1 (8).jpeg", "video": "" }
        ],
        argainc: [
            { "src": "images/Exhibition Booths & Events/Decor/Arganic/1 (1).jpg", "video": "" },
            { "src": "images/Exhibition Booths & Events/Decor/Arganic/1 (2).jpg", "video": "" },
            { "src": "images/Exhibition Booths & Events/Decor/Arganic/1 (3).jpg", "video": "" },
            { "src": "images/Exhibition Booths & Events/Decor/Arganic/1 (4).jpg", "video": "" },
            { "src": "images/Exhibition Booths & Events/Decor/Arganic/1 (5).jpg", "video": "" },
            { "src": "images/Exhibition Booths & Events/Decor/Arganic/1 (6).jpg", "video": "" }
        ],
        farog: [
            { "src": "images/Exhibition Booths & Events/Decor/Farog/1 (1).jpeg", "video": "" },
            { "src": "images/Exhibition Booths & Events/Decor/Farog/1 (2).jpeg", "video": "" },
            { "src": "images/Exhibition Booths & Events/Decor/Farog/1 (3).jpeg", "video": "" },
            { "src": "images/Exhibition Booths & Events/Decor/Farog/1 (4).jpeg", "video": "" },
            { "src": "images/Exhibition Booths & Events/Decor/Farog/1 (5).jpeg", "video": "" },
            { "src": "images/Exhibition Booths & Events/Decor/Farog/1 (6).jpeg", "video": "" }
        ],
        mugla_vid: [   { "src": "images/Exhibition Booths & Events/Photo/4.png", "video": "https://www.youtube.com/watch?v=xs-OSDlYbNs" }

        ],
        allure:  [ { "src": "images/Exhibition Booths & Events/Photo/1.png", "video": "https://www.instagram.com/reel/C4n90NkIgh4/?utm_source=ig_web_copy_link&igsh=MzRlODBiNWFlZA==" },],
        health_care:[  { "src": "images/Exhibition Booths & Events/Photo/3.png", "video": "https://www.instagram.com/reel/C7e1bMxtMIi/?utm_source=ig_web_copy_link&igsh=MzRlODBiNWFlZA==" },],
        sedra:[  { "src": "images/Exhibition Booths & Events/Photo/2.png", "video": "https://www.instagram.com/reel/C4oi4hfoUIj/?utm_source=ig_web_button_share_sheet&igsh=MzRlODBiNWFlZA==" },],
        details_malqa:[  { "src": "images/Exhibition Booths & Events/Tech/2.png", "video": "https://mtcvr.com/DETAILS/Al-Malqa/" },],
        waf:[  { "src": "images/Exhibition Booths & Events/Tech/1.png", "video": "https://my.matterport.com/show/?m=F3tQ3NzHbsW" },],
        king_salman:[  { "src": "images/Exhibition Booths & Events/Tech/4.png", "video": "https://mngha-taif.com/Hospital/index.htm" },],
        higher_learning:[
{ "src": "images/Exhibition Booths & Events/Tech/3.png", "video": "https://my.matterport.com/show/?m=D3X8faowdkC" },],

    };

    const galleryContainer = document.getElementById("gallery-container");
    const relatedContainer = document.getElementById("related-container");

    const lightbox = document.getElementById("lightbox");
    const lightboxImg = document.getElementById("lightbox-img");
    const closeLightbox = document.getElementById("close-lightbox");
    const prevImage = document.getElementById("prev-image");
    const nextImage = document.getElementById("next-image");

    let currentIndex = 0;
    let currentProjectImages = projectImages[title] || [];

    // تحميل صور المعرض باستخدام documentFragment لتحسين الأداء
    const fragment = document.createDocumentFragment();
    
    if (currentProjectImages.length > 0) {
        currentProjectImages.forEach((item, index) => {
            const imgWrapper = document.createElement("div");
            imgWrapper.classList.add("gallery-item");

            const imgElement = document.createElement("img");
            imgElement.src = item.src;
            imgElement.alt = title;
            imgElement.loading = "lazy";
            imgElement.classList.add("gallery-image");

            if (item.video) {
                const playButton = document.createElement("a");
                playButton.href = item.video;
                playButton.target = "_blank";
                playButton.classList.add("play-button");

                const playIcon = document.createElement("img");
                playIcon.src = "images/play-icon.svg";
                playIcon.alt = "مشاهدة الفيديو";
                playIcon.classList.add("play-icon");

                playButton.appendChild(playIcon);
                imgWrapper.appendChild(imgElement);
                imgWrapper.appendChild(playButton);
            } else {
                imgElement.addEventListener("click", function () {
                    openLightbox(index);
                });
                imgWrapper.appendChild(imgElement);
            }

            fragment.appendChild(imgWrapper);
        });
        galleryContainer.appendChild(fragment);
    } else {
        galleryContainer.innerHTML = "<p>لا توجد صور متاحة لهذا المشروع.</p>";
    }

    function openLightbox(index) {
        currentIndex = index;
        lightboxImg.src = currentProjectImages[currentIndex].src;
        lightbox.style.display = "flex";
    }

    function closeLightboxFunc() {
        lightbox.style.display = "none";
    }

    function showPrevImage() {
        currentIndex = (currentIndex > 0) ? currentIndex - 1 : currentProjectImages.length - 1;
        lightboxImg.src = currentProjectImages[currentIndex].src;
    }

    function showNextImage() {
        currentIndex = (currentIndex < currentProjectImages.length - 1) ? currentIndex + 1 : 0;
        lightboxImg.src = currentProjectImages[currentIndex].src;
    }

    closeLightbox.addEventListener("click", closeLightboxFunc);
    prevImage.addEventListener("click", showPrevImage);
    nextImage.addEventListener("click", showNextImage);

    lightbox.addEventListener("click", function (e) {
        if (e.target === lightbox) {
            closeLightboxFunc();
        }
    });

    document.addEventListener("keydown", function (event) {
        if (event.key === "ArrowLeft") {
            showPrevImage();
        } else if (event.key === "ArrowRight") {
            showNextImage();
        } else if (event.key === "Escape") {
            closeLightboxFunc();
        }
    });

    function loadRelatedProjects() {
        const relatedProjects = projects.filter(p => p.category === category && p.title !== title);
        const selectedProjects = relatedProjects.sort(() => 0.5 - Math.random()).slice(0, 4);

        relatedContainer.innerHTML = "";
        selectedProjects.forEach(project => {
            const projectElement = document.createElement("div");
            projectElement.classList.add("related-project");

            projectElement.innerHTML = `
                <a href="gallery.html?title=${project.title}&category=${project.category}">
                    <img src="${project.image}" alt="${project.title}" loading="lazy">
                    <h4 data-translate="${project.title}"></h4>
                </a>
            `;

            relatedContainer.appendChild(projectElement);
        });
    }

    loadRelatedProjects();
});
