/** @format */

"use strict"; // Start of use strict

//Revolution slider
function revolutionSliderActiver() {
  if ($(".rev_slider_wrapper #slider1").length) {
    jQuery("#slider1").revolution({
      sliderType: "standard",
      sliderLayout: "auto",
      dottedOverlay: "yes",
      delay: 5000,
      navigation: {
        arrows: {
          enable: true,
          left: {
            h_align: "left",
            v_align: "center",
            h_offset: 60,
            v_offset: 0,
          },
          right: {
            h_align: "right",
            v_align: "center",
            h_offset: 60,
            v_offset: 0,
          },
        },
      },
      gridwidth: [1200, 940, 720, 480],
      gridheight: [700, 600, 500, 400],
      lazyType: "none",
      parallax: {
        type: "mouse",
        origo: "slidercenter",
        speed: 2000,
        levels: [2, 3, 4, 5, 6, 7, 12, 16, 10, 50],
      },
      shadow: 0,
      spinner: "off",
      stopLoop: "off",
      stopAfterLoops: -1,
      stopAtSlide: -1,
      shuffle: "off",
      autoHeight: "off",
      hideThumbsOnMobile: "off",
      hideSliderAtLimit: 0,
      hideCaptionAtLimit: 0,
      hideAllCaptionAtLilmit: 0,
      debugMode: false,
      fallbacks: {
        simplifyAll: "off",
        nextSlideOnWindowFocus: "off",
        disableFocusListener: false,
      },
    });
  }
}

//Main menu
function mainmenu() {
  var navcollapse = $(".main-menu .navigation li");
  navcollapse.hover(function () {
    $(this).children("ul").stop(true, false, true).slideToggle(300);
  });
  //Submenu Dropdown Toggle
  if ($(".main-menu .mobile-menu li.dropdown ul").length) {
    $(".main-menu .mobile-menu li.dropdown").append(
      '<div class="dropdown-btn"></div>'
    );

    //Dropdown Button
    $(".main-menu .mobile-menu li.dropdown .dropdown-btn").on(
      "click",
      function () {
        $(this).prev("ul").slideToggle(500);
      }
    );
  }
}

//Header Sticky
function stickyHeader() {
  if ($(".stricky").length) {
    var strickyScrollPos = 100;
    if ($(window).scrollTop() > strickyScrollPos) {
      $(".stricky").addClass("stricky-fixed");
      $(".scroll-to-top").fadeIn(1500);
    } else if ($(this).scrollTop() <= strickyScrollPos) {
      $(".stricky").removeClass("stricky-fixed");
      $(".scroll-to-top").fadeOut(1500);
    }
  }
}

//Gallery fancybox activator
function GalleryFancyboxActivator() {
  var galleryFcb = $(".fancybox");
  if (galleryFcb.length) {
    galleryFcb.fancybox({
      openEffect: "elastic",
      closeEffect: "elastic",
      helpers: {
        media: {},
      },
    });
  }
}

//Select menu
function selectMenu() {
  if ($(".select-menu").length) {
    $(".select-menu").selectmenu();
  }
}

//tool_tip
function tooltip() {
  if ($(".tool_tip").length) {
    $(".tool_tip").tooltip();
  }
  $;
}

//Progress Bar / Levels
if ($(".progress-levels .progress-box .bar-fill").length) {
  $(".progress-box .bar-fill").each(function () {
    var progressWidth = $(this).attr("data-per ");
    $(this).css("width", progressWidth + "%");
    $(this)
      .children(".per ")
      .html(progressWidth + "%");
  });
}

//Client carousel
function clientCarousel() {
  if ($(".client-carousel").length) {
    $(".client-carousel.owl-carousel").owlCarousel({
      loop: true,
      margin: 30,
      nav: false,
      dots: false,
      autoWidth: false,
      autoplay: true,
      autoplayTimeout: 1000,
      autoplayHoverPause: true,
      responsive: {
        0: {
          items: 1,
          autoWidth: false,
        },
        380: {
          items: 2,
          autoWidth: false,
        },
        540: {
          items: 3,
          autoWidth: false,
        },
        740: {
          items: 4,
          autoWidth: false,
        },
        1000: {
          items: 5,
          autoWidth: false,
        },
      },
    });
  }
}

//Testimonials Carousel Slider
if ($(".testimonials-carousel").length) {
  $(".testimonials-carousel").owlCarousel({
    loop: true,
    margin: 30,
    nav: false,
    dots: true,
    autoplayHoverPause: false,
    autoplay: false,
    smartSpeed: 10000,
    navText: [
      '<span class="fa fa-angle-left"></span>',
      '<span class="fa fa-angle-right"></span>',
    ],
    responsive: {
      0: {
        items: 1,
      },
      600: {
        items: 1,
      },
      760: {
        items: 2,
      },
      1024: {
        items: 3,
      },
      1100: {
        items: 3,
      },
    },
  });
}

//Four Item Carousel
if ($(".four-item-carousel").length) {
  $(".four-item-carousel").owlCarousel({
    loop: true,
    margin: 30,
    nav: true,
    smartSpeed: 100,
    autoplay: true,
    autoplayTimeout: 2000,
    navText: [
      '<span class="fa fa-angle-left"></span>',
      '<span class="fa fa-angle-right"></span>',
    ],
    responsive: {
      0: {
        items: 1,
      },
      600: {
        items: 2,
      },
      800: {
        items: 2,
      },
      1024: {
        items: 3,
      },
      1200: {
        items: 4,
      },
    },
  });
}

//Four Item Carousel
if ($(".five-item-carousel").length) {
  $(".five-item-carousel").owlCarousel({
    loop: true,
    margin: 10,
    nav: true,
    smartSpeed: 100,
    autoplay: 4000,
    navText: [
      '<span class="fa fa-angle-left"></span>',
      '<span class="fa fa-angle-right"></span>',
    ],
    responsive: {
      0: {
        items: 1,
      },
      600: {
        items: 2,
      },
      800: {
        items: 3,
      },
      1024: {
        items: 4,
      },
      1200: {
        items: 5,
      },
    },
  });
}

// Fact Counter
function factCounter() {
  if ($(".fact-counter").length) {
    $(".fact-counter .counter-column.animated").each(function () {
      var $t = $(this),
        n = $t.find(".count-text").attr("data-stop"),
        r = parseInt($t.find(".count-text").attr("data-speed"), 10);

      if (!$t.hasClass("counted")) {
        $t.addClass("counted");
        $({
          countNum: $t.find(".count-text").text(),
        }).animate(
          {
            countNum: n,
          },
          {
            duration: r,
            easing: "linear",
            step: function () {
              $t.find(".count-text").text(Math.floor(this.countNum));
            },
            complete: function () {
              $t.find(".count-text").text(this.countNum);
            },
          }
        );
      }
    });
  }
}

//Mixit gallery
function fleetGallery() {
  if ($(".mixit-gallery").length) {
    $(".mixit-gallery").mixItUp();
  }
}

//Video Fancybox
function brandingFancybox() {
  if ($("a.branding-fancybox").length) {
    $("a.branding-fancybox").on("click", function () {
      $.fancybox({
        padding: 0,
        autoScale: false,
        transitionIn: "none",
        transitionOut: "none",
        title: this.title,
        width: 680,
        height: 495,
        href: this.href.replace(new RegExp("watch\\?v=", "i"), "v/"),
        type: "swf",
        openEffect: "elastic",
        closeEffect: "elastic",
        helpers: {
          media: {},
        },
        swf: {
          wmode: "transparent",
          allowfullscreen: "true",
        },
      });

      return false;
    });
  }
}

//Select menu
function selectDropdown() {
  if ($(".selectmenu").length) {
    $(".selectmenu").selectmenu();

    var changeSelectMenu = function (event, item) {
      $(this).trigger("change", item);
    };
    $(".selectmenu").selectmenu({ change: changeSelectMenu });
  }
}

//Prealoder
function handlePreloader() {
  if ($(".preloader").length) {
    $(".preloader").delay(200).fadeOut(500);
  }
}

//Scroll to top
function scrollToTop() {
  if ($(".scroll-top").length) {
    //Check to see if the window is top if not then display button
    $(window).scroll(function () {
      if ($(this).scrollTop() > 200) {
        $(".scroll-top").fadeIn();
      } else {
        $(".scroll-top").fadeOut();
      }
    });

    //Click event to scroll to top
    $(".scroll-top").on("click", function () {
      $("html, body").animate({ scrollTop: 0 }, 1500);
      return false;
    });
  }
}

//Flexslider
function singleProduct() {
  $(".flexslider").flexslider({
    animation: "slide",
    controlNav: "thumbnails",
  });
}


//Contact Form Validation
if ($("#contact-form").length) {
  $("#contact-form").validate({
    submitHandler: function (form) {
      var form_btn = $(form).find('button[type="submit"]');
      var form_result_div = "#form-result";
      $(form_result_div).remove();
      form_btn.before(
        '<div id="form-result" class="alert alert-success" role="alert" style="display: none;"></div>'
      );
      var form_btn_old_msg = form_btn.html();
      form_btn.html(form_btn.prop("disabled", true).data("loading-text"));
      $(form).ajaxSubmit({
        dataType: "json",
        success: function (data) {
          if (data.status == "true") {
            $(form).find(".form-control").val("");
          }
          form_btn.prop("disabled", false).html(form_btn_old_msg);
          $(form_result_div).html(data.message).fadeIn("slow");
          setTimeout(function () {
            $(form_result_div).fadeOut("slow");
          }, 6000);
        },
      });
    },
  });
}

// Elements Animation
if ($(".wow").length) {
  var wow = new WOW({
    boxClass: "wow", // animated element css class (default is wow)
    animateClass: "animated", // animation css class (default is animated)
    offset: 0, // distance to the element when triggering the animation (default is 0)
    mobile: true, // trigger animations on mobile devices (default is true)
    live: true, // act on asynchronously loaded content (default is true)
  });
  wow.init();
}

//Instance of fuction while Document ready event
jQuery(document).on("ready", function () {
  (function ($) {
    revolutionSliderActiver();
    selectMenu();
    tooltip();
    fleetGallery();
    GalleryFancyboxActivator();
    brandingFancybox();
    selectDropdown();
    handlePreloader();
    scrollToTop();
    singleProduct();
    mainmenu();
  })(jQuery);
});

//Instance of fuction while Window Load event
jQuery(window).on("load", function () {
  (function ($) {
    clientCarousel();
  })(jQuery);
});

//Instance of fuction while Window Scroll event
jQuery(window).on("scroll", function () {
  (function ($) {
    stickyHeader();
    factCounter();
  })(jQuery);
});

document.addEventListener("DOMContentLoaded", function () {
  const projects = [
    {
      image: "images/Exhibition Booths & Events/Booths/Santen3/8.jpg",
      title: "santen3",
    
      category: "branding",
    },
    {
      image: "images/Exhibition Booths & Events/Booths/Santen 2/3.jpg",
      title: "santen2",
    
      category: "branding",
    },
    {
      image: "images/Exhibition Booths & Events/Booths/Santen/03.jpg",
      title: "santen",
    
      category: "branding",
    },
    {
      image: "images/Exhibition Booths & Events/Booths/AKSUM Armored/01.jpg",
      title: "askum_armored",
      category: "branding",
    },
    {
      image: "images/Exhibition Booths & Events/Booths/AKSUM Marine/02.jpg",
      title: "askum_marine",
      category: "branding",
    },
    {
      image: "images/Exhibition Booths & Events/Booths/Almera Foods/03.jpg",
      title: "almera_foods",
      category: "branding",
    },
    {
      image: "images/Exhibition Booths & Events/Booths/Anti-Corruption Forum/15.jpg",
      title: "moe",
     
      category: "branding",
    },
    {
      image: "images/Exhibition Booths & Events/Booths/BRF/01.jpg",
      title: "brf",
     
      category: "branding",
    },
    {
      image: "images/Exhibition Booths & Events/Booths/Damak/01.jpg",
      title: "damak",
     
      category: "branding",
    },
    {
      image: "images/Exhibition Booths & Events/Booths/Delta Plast/Wide (5).jpg",
      title: "delta_plast",
  
      category: "branding",
    },
   
    {
      image: "images/Exhibition Booths & Events/Booths/Hero One/01.jpg",
      title: "hero_one",
      
      category: "branding",
    },
    {
      image: "images/Exhibition Booths & Events/Booths/Evaco/03.jpg",
      title: "evaco",
     
      category: "branding",
    },
    {
      image: "images/Exhibition Booths & Events/Booths/Falcon/04.jpg",
      title: "falcon",
    
      category: "branding",
    },
    {
      image: "images/Exhibition Booths & Events/Booths/INKAS/01.jpg",
      title: "inkas",
      
      category: "branding",
    },
    {
      image: "images/Exhibition Booths & Events/Booths/Jazirah aviation club/04.jpg",
      title: "jac",
     
      category: "branding",
    },
    {
      image: "images/Exhibition Booths & Events/Booths/Kratos Glass/01.jpg",
      title: "kratos",
    
      category: "branding",
    },
    {
      image: "images/Exhibition Booths & Events/Booths/Riyadh Chamber/01.jpg",
      title: "riyadh_chamber",
   
      category: "branding",
    },
    {
      image: "images/Exhibition Booths & Events/Booths/SMC Hospital/10.jpg",
      title: "smc",
   
      category: "branding",
    },
    {
      image: "images/Exhibition Booths & Events/Booths/Sports Council/01.jpg",
      title: "adsc",
   
      category: "branding",
    },
    {
      image: "images/Exhibition Booths & Events/Booths/Unilime/01.jpg",
      title: "unilime",
    
      category: "branding",
    },
    {
      image: "images/Exhibition Booths & Events/Booths/UNI-Recycling/01.jpg",
      title: "unirecycling",
    
      category: "branding",
    },
    {
      image: "images/Exhibition Booths & Events/Events/Maili _ Sinclair/1 (1).jpg",
      title: "sinclair",
    
      category: "logo",
    },
    {
      image: "images/Exhibition Booths & Events/Booths/Sinclir/1.jpg",
      title: "sinclair2",
    
      category: "branding",
    },
    {
      image: "images/Exhibition Booths & Events/Events/Ministry leaders workshop/1.jpg",
      title: "ministry",
    
      category: "logo",
    },
    {
      image: "images/Exhibition Booths & Events/Events/Ministry of Agriculture event/01.jpg",
      title: "moaevent",
    
      category: "logo",
    },
    {
      image: "images/Exhibition Booths & Events/Events/Mo_asher/01.png",
      title: "moasher",
    
      category: "logo",
    },
    {
      image: "images/Exhibition Booths & Events/Events/Verkazia/01.jpg",
      title: "verkazia",
    
      category: "logo",
    },
    {
      image: "images/Exhibition Booths & Events/Decor/Mugla/1 (2).jpeg",
      title: "mugla",
    
      category: "illustration",
    },
    {
      image: "images/Exhibition Booths & Events/Decor/Arganic/1 (1).jpg",
      title: "argainc",
    
      category: "illustration",
    },
    {
      image: "images/Exhibition Booths & Events/Decor/Farog/1 (1).jpeg",
      title: "farog",
    
      category: "illustration",
    },
    {
      image: "images/Exhibition Booths & Events/Photo/4.png",
      title: "mugla_vid",
    
      category: "video",
    },
    {
      image: "images/Exhibition Booths & Events/Photo/1.png",
      title: "allure",
    
      category: "video",
    },
    {
      image: "images/Exhibition Booths & Events/Photo/3.png",
      title: "health_care",
    
      category: "video",
    },
    {
      image: "images/Exhibition Booths & Events/Photo/2.png",
      title: "sedra",
    
      category: "video",
    },
    {
      image: "images/Exhibition Booths & Events/Tech/2.png",
      title: "details_malqa",
    
      category: "tech",
    },
    {
      image: "images/Exhibition Booths & Events/Tech/1.png",
      title: "waf",
    
      category: "tech",
    },
    {
      image: "images/Exhibition Booths & Events/Tech/4.png",
      title: "king_salman",
    
      category: "tech",
    },
    {
      image: "images/Exhibition Booths & Events/Tech/3.png",
      title: "higher_learning",
    
      category: "tech",
    },
 
 
    
  ];

  projects.sort(() => Math.random() - 0.5);

  const container = document.querySelector(".filter-list");
  container.innerHTML = ""; // تأكد من عدم تكرار المشاريع عند التحميل

  projects.forEach((project) => {
    if (project.image.trim() !== "") {
      const projectHTML = `
        <div class="projects-block-one mix ${project.category} col-lg-4 col-md-4 col-sm-6 col-xs-12">
          <div class="inner-box" data-title="${project.title}" data-category="${project.category}">
            <figure class="image">
              <img src="${project.image}" alt="${project.title}" loading="lazy">
              <div class="overlay">
               
              </div>
            </figure>
            <div class="caption-title">
              <h3 data-translate="${project.title}">
                ${project.title.replace(/_/g, " ")}
              </h3>
            </div>
          </div>
        </div>
      `;
      container.innerHTML += projectHTML;
    }
  });
  // إضافة حدث عند النقر على المشروع لنقل المستخدم إلى صفحة المعرض
  document.querySelectorAll(".inner-box").forEach((projectElement) => {
    projectElement.addEventListener("click", function () {
      const title = this.getAttribute("data-title");
      const category = this.getAttribute("data-category");

      // إعادة التوجيه إلى صفحة المعرض مع تمرير بيانات المشروع
      window.location.href = `gallery.html?title=${title}&category=${category}`;
    });
  });
  //Filter-list
if ($(".filter-list").length) {
  $(".filter-list").mixItUp({});
}


  // عرض العناصر الافتراضية (الجميع) عند التحميل
  document.querySelectorAll(".projects-block-one").forEach((project) => {
    project.style.display = "block";
  });
});
function changeLanguage(lang) {
  fetch(`lang/${lang}.json`)
    .then((response) => {
      if (!response.ok) {
        throw new Error("Failed to load translations");
      }
      return response.json();
    })
    .then((translations) => {
      const elements = document.querySelectorAll("[data-translate]");
      elements.forEach((element) => {
        const key = element.getAttribute("data-translate");
        if (translations[key]) {
          if (element.tagName === "INPUT" || element.tagName === "TEXTAREA") {
            // تحديث قيمة الـ placeholder
            element.setAttribute("placeholder", translations[key]);
          } else if (element.tagName === "BUTTON") {
            // تحديث نص الزر
            element.textContent = translations[key];
          } else {
            // تحديث النصوص الأخرى
            element.textContent = translations[key];
          }
        }
      });

      // تحديث محاذاة النصوص بناءً على اللغة
      const body = document.body;
      if (lang === "ar") {
        body.classList.remove("text-align-left");
        body.classList.add("text-align-right");
      } else {
        body.classList.remove("text-align-right");
        body.classList.add("text-align-left");
      }

      // تغيير الخطوط للعناوين فقط
      applyFontStyles(lang);

      // حفظ اللغة في localStorage
      localStorage.setItem("language", lang);
    })
    .catch((error) => console.error("Error loading translations:", error));
}

// تغيير الخطوط بناءً على اللغة
function applyFontStyles(lang) {
  const headings = document.querySelectorAll("h1, h2, h3, h4, h5, h6");
  const navLinks = document.querySelectorAll(".navigation li a");

  if (lang === "ar") {
    headings.forEach((heading) => {
      heading.style.fontFamily = "'Tajawal', sans-serif";
    });
    navLinks.forEach((link) => {
      link.style.fontFamily = "'Tajawal', sans-serif";
    });
  } else {
    headings.forEach((heading) => {
      heading.style.fontFamily = "'fontastique', sans-serif";
    });
    navLinks.forEach((link) => {
      link.style.fontFamily = "'fontastique', sans-serif";
    });
  }
}

// استدعاء اللغة الافتراضية عند تحميل الصفحة
document.addEventListener("DOMContentLoaded", () => {
  const savedLang = localStorage.getItem("language") || "en"; // اللغة الافتراضية هي الإنجليزية
  changeLanguage(savedLang);
});

// زر التبديل بين اللغات
function setLanguage(lang) {
  localStorage.setItem("language", lang);
  changeLanguage(lang);
}

document.addEventListener("DOMContentLoaded", function () {
    const form = document.getElementById("contact-form");
    const responseMessage = document.createElement("div");
    responseMessage.style.marginTop = "15px";
    form.appendChild(responseMessage);

    form.addEventListener("submit", function (event) {
        event.preventDefault(); // منع إعادة تحميل الصفحة

        let formData = new FormData(form);

        fetch("inc/sendmail.php", {
            method: "POST",
            body: formData
        })
        .then(response => response.json())
        .then(data => {
            responseMessage.innerHTML = `<p style="color: ${data.status === 'success' ? 'green' : 'red'};">${data.message}</p>`;
            if (data.status === "success") {
                form.reset(); // إعادة تعيين الفورم بعد الإرسال الناجح
            }
        })
        .catch(error => {
            responseMessage.innerHTML = `<p style="color: red;">حدث خطأ أثناء إرسال الطلب. حاول مرة أخرى.</p>`;
        });
    });
});